{**************************************************************************************
* Copyright (c) 2001, Beijing SenseLock Info. & Secu. Inc.
* All rights reserved.
*
* FileNameSense4Dev.inc
* BriefsEliteIV library interface declaration, return value and some constant definition.
*
* History:
*  ------------------------------------------------------------
*  2003/08/19 v2.2.0.5 huangjian created
*  2004/3/23  v2.3.0.1 lihua modified
*                      add function declaration for v2.3
*  2004/4/06  v2.3.0.2 lihua modified
*                      add function declaration and constant in psense4.h
*  2004/04/09 v2.3.1.0 Lihua modified
*                      note: uniform the version
*  2004/04/23 v2.3.1.0 Lihua modified
*                      add functionality to set usb mode and hid mode
*  2005/01/04 v2.3.3.0 huangJian modified
*                      add functionality to get customer name, manufacture date and real clock
*  2009/09/09 v3.3.0.0 MaJicheng modified
*                      S4MODULEINFO Update to 64 in S4NETCONFIG
*******************************************************************************************}
uses
{$IF CompilerVersion >= 23}
	// XE2 ϰ汾ͷļ
  Winapi.Windows, System.SysUtils;
{$ELSE}
  // XE°汾Delphi7ͷļռ
	windows, SysUtils;
{$IFEND}

const
  // device version definition
  SENSE4_CARD_TYPE_V2_00                      =$00020000;   // version 2.0
  SENSE4_CARD_TYPE_V2_01                      =$00020001;   // version 2.1
  SENSE4_CARD_TYPE_V2_02                      =$00020002;   // version 2.2
  SENSE4_CARD_TYPE_V2_05                      =$00020005;   // version 2.05
  SENSE4_CARD_TYPE_V2_30                      =$00020300;   // version 2.3
  SENSE4_CARD_TYPE_V5_12                      =$00050102;   // version 5.12


  MAX_ATR_LEN                                 =56;          // max ATR length
  MAX_ID_LEN                                  =8;           // max device ID length
  S4_RSA_MODULUS_LEN                          =128;
  S4_RSA_PRIME_LEN                            =64;
  
  // parameters for S4OpenEx
  S4_EXCLUSIZE_MODE                           =0;         //exclusive mode
  S4_SHARE_MODE                               =1;         //share mode

  // ctlcode definition for S4Control
  S4_LED_UP                                   =$00000004;   // LED up
  S4_LED_DOWN                                 =$00000008;   // LED down
  S4_LED_WINK                                 =$00000028;   // LED wink
  S4_GET_DEVICE_TYPE                          =$00000025;   // get device type
  S4_GET_SERIAL_NUMBER                        =$00000026;   // get device global serial number
  S4_GET_VM_TYPE                              =$00000027;   // get vm type
  S4_GET_DEVICE_USABLE_SPACE                  =$00000029;   // get the total space of the device
  S4_SET_DEVICE_ID                            =$0000002a;   // set the device ID
  S4_RESET_DEVICE                             =$00000002;   // reset device
  S4_DF_AVAILABLE_SPACE                       =$00000031;   // get the free space of current directory
  S4_EF_INFO                                  =$00000032;   // get specified file information in current directory
  S4_SET_USB_MODE                             =$00000041;   // set the device as a normal usb device
  S4_SET_HID_MODE                             =$00000042;   // set the device as a HID device
  S4_GET_CUSTOMER_NAME                        =$0000002b;   // get the customer number
  S4_GET_MANUFACTURE_DATE                     =$0000002c;   // get the manufacture date of the device
  S4_GET_CURRENT_TIME                         =$0000002d;   // get the current time of the clock device
  S4_SET_NET_CONFIG                           =$00000030;   // set config information of the net device

  
  S4_GET_LICENSE                              =$0000002e;   // get the license
  S4_FREE_LICENSE                             =$0000002f;   // free the license
  S4_RESET_LICENSE                            =$00000033;   // Reset the license

  // device type definition
  S4_LOCAL_DEVICE                             =$00;         // local device
  S4_MASTER_DEVICE                            =$01;         // net master device
  S4_SLAVE_DEVICE                             =$02;         // net slave device

  // vm type definition 
  S4_VM_51                                    =$00;         // VM51
  S4_VM_251_BINARY                            =$01;         // VM251 binary
  S4_VM_251_SOURCE                            =$02;         // VM251 source

  // NetLock license mode
  S4_MODULE_MODE                              =$00000000;   // Module mode
  S4_IP_MODE                                  =$00000001;   // IP mode

  // PIN type
  S4_USER_PIN                                 =$000000a1;   // user PIN
  S4_DEV_PIN                                  =$000000a2;   // developer PIN  
  S4_AUTHEN_PIN                               =$000000a3;   // authentication key of net device

  // file type definition
  S4_RSA_PUBLIC_FILE                          =$00000006;   // RSA public key
  S4_RSA_PRIVATE_FILE                         =$00000007;   // RSA private key
  S4_EXE_FILE                                 =$00000008;   // executable file of vm
  S4_DATA_FILE                                =$00000009;   // data file
  S4_XA_EXE_FILE                              =$0000000b;   // executable file of XA User mode
  
  // flag value definition
  S4_CREATE_NEW                               =$000000a5;   // create a new file
  S4_UPDATE_FILE                              =$000000a6;   // write data to the specified file
  S4_KEY_GEN_RSA_FILE                         =$000000a7;   // generate RSA key pair files
  S4_SET_LICENCES                             =$000000a8;   // set the max license number of the current module for the net device
  S4_CREATE_ROOT_DIR                          =$000000ab;   // create root directory
  S4_CREATE_SUB_DIR                           =$000000ac;   // create child directory for current directory
  S4_CREATE_MODULE                            =$000000ad;   // create a module directory for the net device
  
  // the following three flags can only be used when creating a new executable file
  S4_FILE_READ_WRITE                          =$00000000;   // the new executable file can be read and written by executable file
  S4_FILE_EXECUTE_ONLY                        =$00000100;   // the new executable file can't be read or written by executable file
  S4_CREATE_PEDDING_FILE                      =$00002000;   // create a padding file
  
  //execuable file executing mode definition
  S4_VM_EXE                                   =$00000000;   // executing on virtual machine
  S4_XA_EXE                                   =$00000001;   // executing on XA User mode

  //parameters for PS4Writefile
  S4_HEX_FILE                                 =$0000000a;   // supplement parameter to download hex file
  S4_XA_HEX_FILE                              =$0000000c;   // supplement parameter to download xa hex file

  // return code, for more detail please refer to the manual
  S4_SUCCESS                                  =$00000000;   // success
  S4_UNPOWERED                                =$00000001;
  S4_INVALID_PARAMETER                        =$00000002;
  S4_COMM_ERROR                               =$00000003;
  S4_PROTOCOL_ERROR                           =$00000004;
  S4_DEVICE_BUSY                              =$00000005;
  S4_KEY_REMOVED                              =$00000006;
  S4_INSUFFICIENT_BUFFER                      =$00000011;
  S4_NO_LIST                                  =$00000012;
  S4_GENERAL_ERROR                            =$00000013;
  S4_UNSUPPORTED                              =$00000014;
  S4_DEVICE_TYPE_MISMATCH                     =$00000020;
  S4_FILE_SIZE_CROSS_7FFF                     =$00000021;
  S4_CURRENT_DF_ISNOT_MF                      =$00000201;
  S4_INVAILABLE_MODULE_DF                     =$00000202;
  S4_FILE_SIZE_TOO_LARGE                      =$00000203;
  S4_DF_SIZE                                  =$00000204;
  S4_DEVICE_UNSUPPORTED                       =$00006a81;
  S4_FILE_NOT_FOUND                           =$00006a82;
  S4_INSUFFICIENT_SECU_STATE                  =$00006982;
  S4_DIRECTORY_EXIST                          =$00006901;
  S4_FILE_EXIST                               =$00006a80;
  S4_INSUFFICIENT_SPACE                       =$00006a84;
  S4_OFFSET_BEYOND                            =$00006B00;
  S4_PIN_BLOCK                                =$00006983;
  S4_FILE_TYPE_MISMATCH                       =$00006981;
  S4_CRYPTO_KEY_NOT_FOUND                     =$00009403;
  S4_APPLICATION_TEMP_BLOCK                   =$00006985;
  S4_APPLICATION_PERM_BLOCK                   =$00009303;
  S4_DATA_BUFFER_LENGTH_ERROR                 =$00006700;
  S4_CODE_RANGE                               =$00010000;
  S4_CODE_RESERVED_INST                       =$00020000;
  S4_CODE_RAM_RANGE                           =$00040000;
  S4_CODE_BIT_RANGE                           =$00080000;
  S4_CODE_SFR_RANGE                           =$00100000;
  S4_CODE_XRAM_RANGE                          =$00200000;
  S4_ERROR_UNKNOWN                            =$ffffffff;
  S4WF_INVALID_S4CONTEXT                      =$00000101;
  S4WF_INVALID_FILE_ID                        =$00000102;
  S4WF_INVALID_PC_FILE                        =$00000103;
  S4WF_INVALID_FLAGS                          =$00000104;
  S4WF_INVALID_FILE_SIZE                      =$00000105;
  S4WF_INVALID_FILE_TYPE                      =$00000106;

  // device information structure definition
type
  SENSE4_CONTEXT = record
    dwIndex: DWORD;                                         // device index; index begins at zero
    dwVersion: DWORD;                                       // device version
    hLock: THANDLE;                                         // device handle
    reserve: array [0..11] of BYTE;                         // reserved
    bAtr: array [0..MAX_ATR_LEN - 1] of BYTE;               // ATR
    bID:  array [0..MAX_ID_LEN - 1] of BYTE;                // ID
    dwAtrLen: DWORD;                                        // ATR length
  end;
  PSENSE4_CONTEXT = ^SENSE4_CONTEXT;

  //RSA public key structure
  S4_RSA_PUBLIC_KEY = record
    modulus: array [0..S4_RSA_MODULUS_LEN - 1] of byte;     // modulus
    exponent: array [0..S4_RSA_MODULUS_LEN - 1] of byte;    // public exponent
  end;

  //RSA private key structure
  S4_RSA_PRIVATE_KEY = record
    modulus: array [0..S4_RSA_MODULUS_LEN - 1] of byte;            //moduls
    publicExponent: array [0..S4_RSA_MODULUS_LEN - 1] of byte;     //public exponent
    exponent: array [0..S4_RSA_MODULUS_LEN - 1] of byte;           //private exponent
    prime: array [0..1, 0..S4_RSA_PRIME_LEN - 1] of byte;          //prime factors
    primeExponent: array [0..1, 0..S4_RSA_PRIME_LEN - 1] of byte;  //exponents for CRT
    coefficient: array [0..S4_RSA_PRIME_LEN - 1] of byte;          //CRT coefficient
  end;

  // Netlock Module infomation definition
  S4MODULEINFO = record
    wModuleID: WORD;                                               // Module ID
    wLicenseCount: WORD;                                           // License Count
  end;

  S4NETCONFIG = record
    dwLicenseMode: DWORD;                                          // License Mode
    dwModuleCount: DWORD;                                          // Module Count
    ModuleInfo: array[0..63] of S4MODULEINFO;                      // Module detail infomation
  end;

  // S4CREATEDIRINFO structure definition
  S4CreateDirInfo = record
        dwS4CreateDirInfoSize:DWORD;
        szAtr:array[0..7] of BYTE;
        NetConfig:S4NETCONFIG;
  end;
  PS4CreateDirInfo = ^S4CreateDirInfo;

  // S4OPENINFO structure definition
  S4OpenInfo = record
    dwS4OpenInfoSize:DWORD;
    dwShareMode:DWORD;
  end;
  PS4OpenInfo = ^S4OpenInfo;

  // file information definition
  EFINFO = record
    EfID: WORD;
    EfType:BYTE;
    EfSize:WORD;
  end;
  PEFINFO = ^EFINFO;

  //device manufacture date structure definition
  TS4_MANUFACTURE_DATE = record
    wYear:WORD;
    byMonth:BYTE;
    byDay:BYTE;
  end;
  PS4_MANUFACTURE_DATE = ^TS4_MANUFACTURE_DATE;


  TM = record
        tm_sec:Integer;     // seconds after the minute - [0,59]
        tm_min:Integer;     // minutes after the hour - [0,59]
        tm_hour:Integer;    // hours since midnight - [0,23]
        tm_mday:Integer;    // day of the month - [1,31]
        tm_mon:Integer;     // months since January - [0,11]
        tm_year:Integer;    // years since 1900
        tm_wday:Integer;    // days since Sunday - [0,6]
        tm_yday:Integer;    // days since January 1 - [0,365]
        tm_isdst:Integer;   // daylight savings time flag 
  end;
  PTM = ^TM;

//abolished
function  S4Startup():DWORD;stdcall;

//abolished
function  S4Cleanup():DWORD;stdcall;

//
//       Parameters:                     [OUT]           pS4CtxList             - return the device list
//                                       [IN] [OUT]      dwCtxListSize          - return the amount of storage of device list, in bytes.
//
//       Description:                   enumerate all EliteIV devices plugged in the computer.
//                                      if pS4CtxList is NULL, the pdwCtxListSize will return the required buffer size
function S4Enum(pS4CtxList: PSENSE4_CONTEXT; var dwCtxListSize: DWORD): DWORD;stdcall;

//
//      Parameters:                      [IN][OUT]       pS4Ctx                 - the context pointer of the device
//
//      Description:                     open the EliteIV device with sharable mode
//
function S4Open(pS4Ctx: PSENSE4_CONTEXT): DWORD;stdcall;

//
//      Parameters:                      [IN]            pS4Ctx                 - the context pointer of the device
//
//
//      Description:                     close the device.
//
function S4Close(pS4Ctx: PSENSE4_CONTEXT): DWORD;stdcall;

//
//      Parameters:                     [IN]            pS4Ctx                 - the context pointer of the device
//                                      [IN]            dwCtlCode              - control code
//                                      [IN]            pInBuffer              - input buffer
//                                      [IN]            dwInBufferLen          - input buffer len
//                                      [OUT]           pOutBuffer             - output buffer
//                                      [IN]            dwOutBufferLen         - output buffer length
//                                      [OUT]           dwBytesReturned        - the length of output data, cannot be NULL
//
//      Description:                    Send control command to device
//
function S4Control(pS4Ctx: PSENSE4_CONTEXT; dwCtlCode: DWORD; pInBuffer: Pointer; dwInBufferLen: DWORD;
         pOutBuffer: Pointer; dwOutBufferLen: DWORD; var dwBytesReturned: DWORD): DWORD;stdcall;

//
//      Parameters:                     [IN]            pS4Ctx                 - the context pointer of the device
//                                      [IN]            lpszDirID              - ID of the new directory
//                                      [IN]            dwDirSize              - size of the new directory
//                                      [IN]            dwFlags                - flag
//
//      Description:                    create a new child directory for the current directory, and set current directory to the new directory
//
function S4CreateDir(pS4Ctx: PSENSE4_CONTEXT; lpszDirID: PAnsiChar; dwDirSize, dwFlags: DWORD): DWORD;stdcall;

//
//      Parameters:                     [IN]            pS4Ctx                 - the context pointer of the device
//                                      [IN]            lpszPath               - ID of the specified directory
//
//      Description:                    set the current directory
//
function S4ChangeDir(pS4Ctx: PSENSE4_CONTEXT; lpszPath: PAnsiChar): DWORD;stdcall;

//
//      Parameters:                     [IN]            pS4Ctx                 - the context pointer of the device
//                                      [IN]            lpszDirID              - must be NULL
///
//
//      Description:                     erase the current directory
//
function S4EraseDir(pS4Ctx: PSENSE4_CONTEXT; lpszDirID: PAnsiChar): DWORD;stdcall;

//
//      Parameters:                     [IN]            pS4Ctx                 - the context pointer of the device
//                                      [IN]            pbPin                  - PIN value
//                                      [IN]            dwPinLen               - PIN length
//                                      [IN]            dwPinType              - PIN type
//
//
//      Description:                    verify the PIN for current directory
//
function S4VerifyPin(pS4Ctx: PSENSE4_CONTEXT; pbPin: PAnsiChar; dwPinLen, dwPinType: DWORD): DWORD;stdcall;

//
//      Parameters:                     [IN]            pS4Ctx                 - the context pointer of the device
//                                      [IN]            pbOldPin               - old PIN value
//                                      [IN]            dwOldPinLen            - old PIN length
//                                      [IN]            pbNewPin               - new PIN value
//                                      [IN]            dwNewPinLen            - new PIN length
//                                      [IN]            dwPinType              - PIN type
//
//
//      Description:                    change PIN for current directory
//
function S4ChangePin(pS4Ctx: PSENSE4_CONTEXT; pbOldPin: PAnsiChar; dwOldPinLen: DWORD;
         pbNewPin: PAnsiChar; dwNewPinLen: DWORD; dwPinType: DWORD): DWORD;stdcall;

//
//      Parameters:                     [IN]            pS4Ctx                 - the context pointer of the device
//                                      [IN]            lpszFileID             - file ID
//                                      [IN]            dwOffset               - offset to write file
//                                      [IN]            pBuffer                - input data buffer
//                                      [IN]            dwBufferSize           - input data length
//                                      [IN]            dwFileSize             - file size
//                                      [OUT]           dwBytesWritten         - return the length of data written into the file
//                                      [IN]            dwFlags                - flag
//                                      [IN]            bFileType              - file type
//
//
//      Description:                    create a new file or update file data
//
function S4WriteFile(pS4Ctx: PSENSE4_CONTEXT; lpszFileID: LPCSTR; dwOffset: DWORD; pBuffer: Pointer;
         dwBufferSize: DWORD; dwFileSize: DWORD; var dwBytesWritten: DWORD; dwFlags: DWORD; 
         bFileType: BYTE): DWORD;stdcall;

//
//      Parameters:                     [IN]            pS4Ctx                 - the context pointer of the device
//                                      [IN]            lpszFileID             - file ID
//                                      [IN]            pInBuffer              - input buffer
//                                      [IN]            dwInbufferSize         - input buffer length
//                                      [OUT]           pOutBuffer             - output buffer 
//                                      [IN]            dwOutBufferSize        - oupput buffer length
//                                      [OUT]           dwBytesReturned        - output length
//
//      
//      Description:                    execute file
//
function S4Execute(pS4Ctx: PSENSE4_CONTEXT; lpszFileID: LPCSTR; pInBuffer: Pointer; dwInbufferSize: DWORD;
         pOutBuffer: Pointer; dwOutBufferSize: DWORD; var dwBytesReturned: DWORD): DWORD;stdcall;
//
//
//      Parameters:                     [IN]            pS4Ctx                 - the context pointer of the device
//                                      [IN]            lpszFileID             - file ID
//                                      [IN]            dwFlag                 - flag
//                                      [IN]            pInBuffer              - input buffer
//                                      [IN]            dwInbufferSize         - input buffer size
//                                      [OUT]           pOutBuffer             - output buffer
//                                      [IN]            dwOutBufferSize        - output buffer size
//                                      [OUT]           dwBytesReturned        - output length
//
//
//      Descrption:                     execute vm file of xa file
//
//
function  S4ExecuteEx(pS4Ctx: PSENSE4_CONTEXT; lpszFileID: LPCSTR; dwFlag:DWORD; pInBuffer:Pointer;
          dwInbufferSize:DWORD; pOutBuffer:Pointer; dwOutBufferSize:DWORD; var BytesReturned:DWORD):DWORD;stdcall;


//      Parameters:                     [IN]           pS4Ctx                  - the context pointer of the device
//                                      [IN]           lpszDirID               - directory ID
//                                      [IN]           dwDirSize               - directory size
//                                      [IN]           dwFlags                 - flag
//                                      [IN]           pRootInfo               - ATR information
//
//      Description:                    create new directory, when create mf, create ATR file

function S4CreateDirEx(pS4Ctx: PSENSE4_CONTEXT; lpszDirID: PAnsiChar; dwDirSize, dwFlags: DWORD;
         pCreateDirInfo:PS4CreateDirInfo): DWORD;stdcall;


//      Parameters:                    [IN]            pS4Ctx                  - the context pointer of the device
//                                     [IN]            pS4OpenInfo             - S4OPENINFO structure pointer
//      Description:                   open the device in exclusive mode or share mode
//
function S4OpenEx(pS4Ctx: PSENSE4_CONTEXT; pOpenInfo:PS4OpenInfo):DWORD;stdcall;

//      Parameters:                     [IN]            pS4Ctx                 - the context pointer of the device
//                                      [IN]            lpszFileID             - file ID
//                                      [IN]            lpszPCFilePath         - file path in PC
//                                      [IN] [OUT]      dwFileSize             - input the file size to be created, return the size created
//                                      [IN]            dwFlags                - flag
//                                      [IN]            dwFileType             - file type
//                                      [OUT]           dwBytesWritten         - byte number written
//
//
//      Description:                     write a pc file into the device
//
function PS4WriteFile(CONST ps4Ctx:PSENSE4_CONTEXT; lpszFileID:LPCSTR; lpszPCFilePath:LPCSTR;
         var dwFileSize:DWORD; dwFlags:DWORD; dwFileType:DWORD; var dwBytesWritten:DWORD):DWORD;stdcall;
