{**************************************************************************************
*  ˼ɷ޹˾ Copyright(C) 1995-2009
*
*  ļƣcrypt2.inc
*  ļʶ
*  ժ    ҪIV㷨Ľӿںֵ壬ԼغĲ
*
*  ʷ¼:
*  ------------------------------------------------------------
*  2007/09/27 v1.0.0.0 MaJicheng  
*******************************************************************************************}
uses SysUtils, windows, Messages;

{
#ifndef __CRYPT_2_H__
#define __CRYPT_2_H__

//#define _XCOS_VERSION 0x0200

#ifdef __cplusplus
extern "C" 
#endif

#if defined WIN32 || defined _WIN32 || defined _WIN64
#include <windows.h>
#else
#define WINAPI
#endif

typedef char                CHAR_T;
typedef unsigned char       UCHAR;
typedef unsigned short      USHORT;
typedef unsigned long       ULONG;
typedef unsigned int        UINT32_T;
typedef int                 INT32_T;
typedef long                LONG32_T;
}

const
  DA_MD2 =3;
  DA_MD5 =5;
  DA_SHS =$1a;

  //Error codes.
  RE_SUCCESS				=$0000;
  RE_CONTENT_ENCODING		=$0400;
  RE_DATA					=$0401;
  RE_DIGEST_ALGORITHM		=$0402;
  RE_ENCODING				=$0403;
  RE_KEY					=$0404;
  RE_KEY_ENCODING			=$0405;
  RE_LEN					=$0406;
  RE_MODULUS_LEN			=$0407;
  RE_NEED_RANDOM			=$0408;
  RE_PRIVATE_KEY			=$0409;
  RE_PUBLIC_KEY			=$040a;
  RE_SIGNATURE			=$040b;
  RE_SIGNATURE_ENCODING	=$040c;
  RE_ENCRYPTION_ALGORITHM	=$040d;
	RE_PARAMETER			=$040e;		// error parameter
	RE_MEMORY				=$040f;		// alloc memory failed

  //ifndef MAX_RSA_MODULUS_BITS
  //RSA key lengths.
  MIN_RSA_MODULUS_BITS	=508;
  MAX_RSA_MODULUS_BITS	=1024;
  MAX_RSA_MODULUS_LEN		=128;  //((MAX_RSA_MODULUS_BITS + 7) / 8);
  MAX_RSA_PRIME_BITS		=512;  //((MAX_RSA_MODULUS_BITS + 1) / 2);
  MAX_RSA_PRIME_LEN		  =64;  //((MAX_RSA_PRIME_BITS + 7) / 8);

  COS_RSA_MODULUS_LEN	=$80;
  COS_RSA_EXP_LEN		=$04;
  COS_RSA_PRIME_LEN	=$40;

type
  PByte = ^Byte;

  //RSA public and private key.
  R_RSA_PUBLIC_KEY = record
    bits: DWORD;                //length in bits of modulus
    modulus: array[0..MAX_RSA_MODULUS_LEN-1] of byte;        //modulus
    exponent: array [0..MAX_RSA_MODULUS_LEN-1]of BYTE;       //public exponent
  end;
  PR_RSA_PUBLIC_KEY = ^R_RSA_PUBLIC_KEY;

  R_RSA_PRIVATE_KEY = record
    bits: DWORD;                           // length in bits of modulus
    modulus: array [0..MAX_RSA_MODULUS_LEN-1] of BYTE;                    // modulus
    publicExponent: array [0..MAX_RSA_MODULUS_LEN-1] of BYTE;     // public exponent
    exponent: array [0..MAX_RSA_MODULUS_LEN-1] of BYTE;          // private exponent
    prime: array [0..1,0..MAX_RSA_PRIME_LEN-1] of BYTE;               // prime factors
    primeExponent: array [0..1,0..MAX_RSA_PRIME_LEN-1] of BYTE;   // exponents for CRT
    coefficient: array [0..MAX_RSA_PRIME_LEN-1] of BYTE;          // CRT coefficient
  end;
  PR_RSA_PRIVATE_KEY = ^R_RSA_PRIVATE_KEY;
  //#endif


  // tlv record format (tag-length-value)
  //CosԿʽھ3 V1.0֧

{$DEFINE _XCOS_VERSION_V200_AFTER}    //defined in Crypt\Source\crypt2.h'

{$IFNDEF _XCOS_VERSION_V200_AFTER}
// start COS_RSA_PUBLIC_KEY struct 
  COS_RSA_PUBLIC_KEY = record
    modulus: array [0..COS_RSA_MODULUS_LEN-1] of BYTE;
    exponent: array [0..COS_RSA_EXP_LEN-1] of BYTE;
  end;
  PCOS_RSA_PUBLIC_KEY = ^COS_RSA_PUBLIC_KEY;
// end COS_RSA_PUBLIC_KEY struct

// start COS_RSA_PRIVATE_KEY struct 
  COS_RSA_PRIVATE_KEY = record
    p: array [0..COS_RSA_PRIME_LEN-1] of BYTE;
	  q: array [0..COS_RSA_PRIME_LEN-1] of BYTE;
    exponent: array [0..COS_RSA_EXP_LEN-1] of BYTE;
  end;
  PCOS_RSA_PRIVATE_KEY = ^COS_RSA_PRIVATE_KEY;
// end COS_RSA_PRIVATE_KEY struct 

{$ELSE}

// start COS_RSA_PUBLIC_KEY struct
  COS_RSA_PUBLIC_KEY_n = record
    tag: Shortint;
    length: BYTE;
    value: array [0..COS_RSA_MODULUS_LEN-1] of BYTE;
  end;
  COS_RSA_PUBLIC_KEY_e = record
    tag: Shortint;
    length: BYTE;
    value: array [0..COS_RSA_EXP_LEN-1] of BYTE;
  end;
  COS_RSA_PUBLIC_KEY = record
    n: COS_RSA_PUBLIC_KEY_n;
    e: COS_RSA_PUBLIC_KEY_e;
  end;
  PCOS_RSA_PUBLIC_KEY = ^COS_RSA_PUBLIC_KEY;
// end COS_RSA_PUBLIC_KEY struct

// start COS_RSA_PRIVATE_KEY_2 struct
  COS_RSA_PRIVATE_KEY_2_n = record
    tag: Shortint;
    length: BYTE;
    value: array [0..COS_RSA_MODULUS_LEN-1] of BYTE;
  end;
  COS_RSA_PRIVATE_KEY_2_d = record
    tag: Shortint;
    length: BYTE;
    value: array [0..COS_RSA_MODULUS_LEN-1] of BYTE;
  end;
  COS_RSA_PRIVATE_KEY_2 = record
    n: COS_RSA_PRIVATE_KEY_2_n;
    d: COS_RSA_PRIVATE_KEY_2_d;
  end;
  PCOS_RSA_PRIVATE_KEY_2 = ^COS_RSA_PRIVATE_KEY_2;
// end COS_RSA_PRIVATE_KEY_2 struct

// start COS_RSA_PRIVATE_KEY struct
  //Cos˽Կʽھ3 V1.0֧
  COS_RSA_PRIVATE_KEY_p = record
    tag: Shortint;
    length: BYTE;
    value: array [0..COS_RSA_PRIME_LEN-1] of BYTE;
  end;
  COS_RSA_PRIVATE_KEY_q = record
    tag: Shortint;
    length: BYTE;
    value: array [0..COS_RSA_PRIME_LEN-1] of BYTE;
  end;
  COS_RSA_PRIVATE_KEY_dp = record
    tag: Shortint;
    length: BYTE;
    value: array [0..COS_RSA_PRIME_LEN-1] of BYTE;
  end;
  COS_RSA_PRIVATE_KEY_dq = record
    tag: Shortint;
    length: BYTE;
    value: array [0..COS_RSA_PRIME_LEN-1] of BYTE;
  end;
  COS_RSA_PRIVATE_KEY_qinv = record
    tag: Shortint;
    length: BYTE;
    value: array [0..COS_RSA_PRIME_LEN-1] of BYTE;
  end;
  COS_RSA_PRIVATE_KEY = record
    p: COS_RSA_PRIVATE_KEY_p;
    q: COS_RSA_PRIVATE_KEY_q;
    dp: COS_RSA_PRIVATE_KEY_dp;
    dq: COS_RSA_PRIVATE_KEY_dq;
    qinv: COS_RSA_PRIVATE_KEY_qinv;
  end;
  PCOS_RSA_PRIVATE_KEY = ^COS_RSA_PRIVATE_KEY;
// end COS_RSA_PRIVATE_KEY struct

{$ENDIF}
 
//RSA key generate functions
function X_GenerateRsaKeys(
  cPubKey: PCOS_RSA_PUBLIC_KEY;
  cPriKey: PCOS_RSA_PRIVATE_KEY
  ):Longint;stdcall;

function R_GenerateRsaKeys(
  pubKey: PR_RSA_PUBLIC_KEY;
  priKey: PR_RSA_PRIVATE_KEY
  ):Longint;stdcall;

//key type convert function
function X_Pub2Cos(
  cPubKey: PCOS_RSA_PUBLIC_KEY;
  pubKey: PR_RSA_PUBLIC_KEY
  ):Longint;stdcall;

function X_Pri2Cos(
  cPriKey: PCOS_RSA_PRIVATE_KEY;
  priKey: PR_RSA_PRIVATE_KEY
  ):Longint;stdcall;

function X_Pri2CosEx(
  iOutType: Longint;
  cPriKey: PCOS_RSA_PRIVATE_KEY;
  priKey: PR_RSA_PRIVATE_KEY
  ):Longint;stdcall;

function X_Cos2Pub(
  pubKey: PR_RSA_PUBLIC_KEY;
  cPubKey: PCOS_RSA_PUBLIC_KEY
  ):Longint;stdcall;

function X_Cos2Pri(
  priKey: PR_RSA_PRIVATE_KEY;
  cPriKey: PCOS_RSA_PRIVATE_KEY
  ):Longint;stdcall;

//RSA Encrypt/Decrypt functions
function RSAPublicEncrypt(
  output: PByte;
  var outputLen: DWORD;
  input: PByte;
  inputLen: DWORD;
  publicKey: PR_RSA_PUBLIC_KEY
  ):Longint;stdcall;

function RSAPrivateDecrypt(
  output: PByte;
  var outputLen: DWORD;
  input: PByte;
  inputLen: DWORD;
  privateKey: PR_RSA_PRIVATE_KEY
  ):Longint;stdcall;

//digest function
function Digest(
  digestAlgorithm: Longint;
  plain: PByte;
  plainLen: DWORD;
  digest: PByte;
  var digestLen: DWORD
  ):Longint;stdcall;

//sign function
function Sign(
  digestAlgorithm: Longint;
  plain: PByte;
  plainLen: DWORD;
  signature: PByte;
  var signatureLen: DWORD;
  privateKey: PR_RSA_PRIVATE_KEY
  ):Longint;stdcall;

//verify function
function Verify(
  digestAlgorithm: Longint;
  plain: PByte;
  plainLen: DWORD;
  signature: PByte;
  signatureLen: DWORD;
  publicKey: PR_RSA_PUBLIC_KEY
  ):Longint;stdcall;

//DES function
function DES(
  key: PByte;
  encrypt: Longint;
  output: PByte;
  input: PByte;
  inputLen: DWORD
  ):Longint;stdcall;

function TDES(
  key: PByte;
  encrypt: Longint;
  output: PByte;
  input: PByte;
  inputLen: DWORD
  ):Longint;stdcall;

//TDES function
function DES3(
  key: PByte;
  encrypt: Longint;
  output: PByte;
  input: PByte;
  inputLen: DWORD
  ):Longint;stdcall;


{
#ifdef __cplusplus

#endif

#endif //__CRYPT_2_H__
}